#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
 
 using namespace std;

struct Mast {
    long long x, h;
    int idx;
};
 
 int main() {
    int n;
    cin >> n;
    
    vector<long long> x(n), h(n);
    vector<Mast> masts(n);
    
     for (int i = 0; i < n; i++) {
        cin >> x[i];
     }
     for (int i = 0; i < n; i++) {
        cin >> h[i];
    }
    
    for (int i = 0; i < n; i++) {
        masts[i] = {x[i], h[i], i};
    }
    
    sort(masts.begin(), masts.end(), [](const Mast& a, const Mast& b) {
        return a.x < b.x;
    });
    
    vector<long long> answers(n, -1);
    
    for (int i = 0; i < n; i++) {
        long long min_dist = LLONG_MAX;
        long long xi = masts[i].x;
        long long hi = masts[i].h;
        
        for (int j = 0; j < n; j++) {
            if (i != j && masts[j].h >= hi) {
                long long dist = abs(masts[j].x - xi);
                min_dist = min(min_dist, dist);
            }
        }
        
        for (int j = 0; j < n - 1; j++) {
            long long x1 = masts[j].x;
            long long h1 = masts[j].h;
            long long x2 = masts[j + 1].x;
            long long h2 = masts[j + 1].h;
            
            long long xt = (h1 - h2 + x1 + x2) / 2;
            long long yt = h1 - (xt - x1);
            
            if (xi >= x1 && xi <= x2) {
                long long y_on_rope;
                if (xi <= xt) {
                    y_on_rope = h1 - (xi - x1);
                } else {
                    y_on_rope = h2 + (xi - x2);
                }
                
                if (y_on_rope >= hi) {
                    long long dist = y_on_rope - hi;
                    min_dist = min(min_dist, dist);
                }
            }
            if (xi < x1 || xi > x2) {
                if (yt >= hi) {
                    long long dx = abs(xt - xi);
                    long long dy = yt - hi;
                    long long dist = (long long)round(sqrt((double)dx * dx + (double)dy * dy));
                    min_dist = min(min_dist, dist);
                }
            }
        }
        
        if (min_dist != LLONG_MAX) {
            answers[masts[i].idx] = min_dist;
        }
    }
    
    for (int i = 0; i < n; i++) {
        cout << answers[i] << "\n";
    }
    
    return 0;
 }